/**
  ********************************************************************************
  *
  * @file    hal_uart.h
  * @brief   Header file of uart driver
  *
  * @version V1.0
  * @data    22 Aug 2018
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  ********************************************************************************
  */

#ifndef __HAL_UART_H__
#define __HAL_UART_H__

#include "hic.h"
#include "type.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @addtogroup UART
  * @{
  */

/**
  * @defgroup Uart_Public_Micros uart Public Micros
  * @{
  */

#define UART_RX_9BIT_CFG(x)	(RX0LEN = ((x) ? 1 : 0))
#define UART_GET_BIT_8(x)	((x) = RX0R8)

#define UART_TX_9BIT_CFG(x)	(TX0LEN = ((x) ? 1 : 0))
#define UART_SET_BIT_8(x)	(TX0R8 = (x))

/**
  * @}
  */
/**
  * @addtogroup Uart_Public_Functions
  * @{
  */

extern hal_status_t uart_init(uint32_t baud);
extern void uart_tx(uint8_t *data);
extern uint8_t uart_rx(void);

/*
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#endif
